﻿using System;
using System.Diagnostics;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create
{
    /// <summary>
    /// Post to Video Visit Service step.
    /// </summary>
    public class PostToVideoVisitServiceStep : FilterBase<VideoVisitCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitCreateStateObject state)
        {
            if (state.ExceptionOccured) return;
            if (!string.IsNullOrEmpty(state.VistaFakeResponseType)) return;

            var vimtTmpCreateAppointmentRequest = new VIMTTmpCreateAppointmentRequest
            {
                OrganizationName = state.OrganizationName,
                UserId = state.UserId,
                LogTiming = false,
                LogSoap = false,
                Debug = false,
                VIMTTmpCreateAppointmentRequestDataInfo = state.Appointment
            };

            vimtTmpCreateAppointmentRequest.VIMTTmpCreateAppointmentRequestDataInfo.SamlToken = state.SamlToken;

            // Call the Enterprise Component to send the meeting info to Vyopta
            try
            {
                var timer = new Stopwatch();
                timer.Start();
                var response = vimtTmpCreateAppointmentRequest.SendReceive<VIMTTmpCreateAppointmentResponse>(MessageProcessType.Local);
                timer.Stop();
                state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
                if (response.ExceptionOccured)
                {
                    state.ExceptionOccured = true;
                    state.ExceptionMessage = response.ExceptionMessage;
                }
                else
                {
                    if (response.VIMTTmpCreateAppointmentResponseDataInfo != null)
                    {
                        state.EcResponse = response;

                        if (response.VIMTTmpCreateAppointmentResponseDataInfo.HttpStatusCode == "OK") return;
                        state.ExceptionOccured = true;
                        state.ExceptionMessage = string.Format("The Video Visit Create Appointment VIMT message failed with HTTP status code {0}", response.VIMTTmpCreateAppointmentResponseDataInfo.HttpStatusCode);
                    }
                    else
                    {
                        state.ExceptionOccured = true;
                        state.ExceptionMessage = "The VIMTTmpCreateAppointmentResponseDataInfo response value is null";
                    }
                }
            }
            catch (Exception ex)
            {
                var exceptionMessage = ex.Message;
                exceptionMessage += PipelineUtilities.BuildErrorMessage(ex);

                state.ExceptionOccured = true;
                state.ExceptionMessage = exceptionMessage;
            }
        }
    }
}